#include <iostream>
#include <set>
#include <map>
#define _USE_MATH_DEFINES
#include <cmath>
#include <algorithm>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <ctime>
#include <random>

using namespace std;

using ll = long long;
using ld = long double;
using vll = vector<ll>;
using vvll = vector<vll>;
using pll = pair<ll, ll>;
using vpll = vector<pll>;

ll INF = 1e18;
ld EPS = 1e-6;

ll MOD = 1e9 + 7;
ll P = 239;
ll B = 350;

minstd_rand generator;

struct Point {
    ll x, y;

    Point operator+(Point &other) const {
        return {x + other.x, y + other.y};
    }

    Point operator-(Point &other) const {
        return {x - other.x, y - other.y};
    }

    Point operator*(ll k) {
        return {x * k, y * k};
    }

    ll operator*(Point &other) const {
        return x * other.x + y * other.y;
    }

    bool operator==(Point &other) {
        return x == other.x && y == other.y;
    }
};

struct Line {
    ll a, b, c;

    Line() {

    }

    Line(Point p1, Point p2) {
        a = p2.y - p1.y;
        b = p1.x - p2.x;
        c = p1.y * p2.x - p1.x * p2.y;
    }
};

struct Seg {
    Point p1, p2;
    Line line;

    Seg() {

    }

    Seg(Point p1, Point p2): p1(p1), p2(p2) {
        line = Line(p1, p2);
    }

    bool intersection(Seg &other) {
        ll a1 = line.a, b1 = line.b, c1 = line.c;
        ll a2 = other.line.a, b2 = other.line.b, c2 = other.line.c;
        if (a1 * b2 != a2 * b1) {
            ld x = (ld)(b1 * c2 - b2 * c1) / (ld)(a1 * b2 - a2 * b1);
            ld y = (ld)(a2 * c1 - a1 * c2) / (ld)(a1 * b2 - a2 * b1);
            bool ok = true;
            ok &= (min(p1.x, p2.x) - EPS <= x && x <= max(p1.x, p2.x) + EPS);
            ok &= (min(p1.y, p2.y) - EPS <= y && y <= max(p1.y, p2.y) + EPS);

            ok &= (min(other.p1.x, other.p2.x) - EPS <= x && x <= max(other.p1.x, other.p2.x) + EPS);
            ok &= (min(other.p1.y, other.p2.y) - EPS <= y && y <= max(other.p1.y, other.p2.y) + EPS);

            return ok;
        } else {
            Point v[4] = {p1, p2, other.p1, other.p2};
            for (ll i = 0; i < 4; i++)
                for (ll j = i + 1; j < 4; j++)
                    if (v[i] == v[j])
                        return true;

            return false;
        }
    }
};

struct DSU {
    vector<ll> p, sz, inter;
    ll cnt;

    DSU(ll n) {
        p.assign(n, 0);
        for (ll i = 0; i < n; i++) p[i] = i;
        sz.assign(n, 1);
        inter.assign(n, 0);
        cnt = n;
    }

    ll get(ll v) {
        if (p[v] == v) return v;
        return p[v] = get(p[v]);
    }

    void merge(ll a, ll b) {
        a = get(a), b = get(b);

        if (a == b) return;
        if (sz[a] < sz[b]) swap(a, b);

        sz[a] += sz[b];
        p[b] = a;
        inter[a] += inter[b];
        cnt--;
    }

    ll getInter(ll v) {
        v = get(v);
        return inter[v];
    }

    void addInter(ll v) {
        v = get(v);
        inter[v]++;
    }
};

int main() {
#ifdef LOCAL
    freopen("inp.txt", "r", stdin);
    freopen("out.txt", "w", stdout);

    clock_t timer = clock();
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    cout.precision(64);
    cout << fixed;
#endif

    ll t;
    cin >> t;

    while (t--) {
        ll n;
        cin >> n;

        vector<Seg> p(n);
        for (ll i = 0; i < n; i++) {
            ll x1, x2, y1, y2;
            cin >> x1 >> y1 >> x2 >> y2;
            Point p1 = {x1, y1}, p2 = {x2, y2};
            p[i] = Seg(p1, p2);
        }

        vector<ll> inter(n, 0);
        DSU dsu(n);

        for (ll i = 0; i < n; i++) {
            for (ll j = i + 1; j < n; j++) {
                if (p[i].intersection(p[j])) {
                    dsu.addInter(i);
                    dsu.merge(i, j);
                }
            }
        }

        ll ans = 1;

        vector<ll> used(n, false);
        for (ll i = 0; i < n; i++) {
            ll v = dsu.get(i);
            if (used[v]) continue;
            used[v] = true;

            ans += dsu.getInter(v) - dsu.sz[v] + 1;
        }

        cout << ans << "\n";
    }

#ifdef LOCAL
    cout << "\nExecution time: " << (ld)(clock() - timer) / CLOCKS_PER_SEC;
#endif
}
